<div class="form-horizontal">
    <div class="form-group">
        <label class="col-sm-2 control-label" for="mg-quantity-apply-type">{$MGLANG->T('Apply To')}</label>
        <div class="col-sm-8">
            <select name="quantity[applyType]" id="mg-quantity-apply-type">
                <option value="all" {if $discount.applyType=="all"}selected{/if}>{$MGLANG->T('All Required Products')}</option>
                <option value="more_expensive" {if $discount.applyType=="more_expensive"}selected{/if}>{$MGLANG->T('more_expensive')}</option>
                <option value="less_expensive" {if $discount.applyType=="less_expensive"}selected{/if}>{$MGLANG->T('less_expensive')}</option>
                <option value="products" {if $discount.applyType=="products"}selected{/if}>{$MGLANG->T('products')}</option>
                <option value="active_services_quantity" {if $discount.applyType=="active_services_quantity"}selected{/if}>{$MGLANG->T('Active Services Quantity')}</option>
            </select>
            <span class="help-block error-block"></span>
        </div>
    </div>
    <div class="form-group" id="mg-quantity-group-price" style="display: none;">
        <label class="col-sm-2 control-label" for="mg-quantity-apply-price-limit">{$MGLANG->T('Price Limit')}</label>
        <div class="col-sm-8">
            <input type="text" data-error="{$MGLANG->T('Field is required')}" placeholder="{$MGLANG->T('PriceLimitPlaceholder')}" id="mg-quantity-apply-price-limit" class="form-control" value="{$discount.priceLimit}" name="quantity[priceLimit]">
            <div class="help-block with-errors"></div>
        </div>
    </div>
    {$promotionalProductsForm}
    <div class="form-group">
        <div class="col-sm-12">
            <legend id="newDiscount_formGroup_promotionalProductsLabel">{$MGLANG->T('Thresholds')}</legend>
        </div>
    </div>
    {section name=k start=0 loop=$loopThresholds step=1}
        {assign var="i" value=$smarty.section.k.index}
        <div class="form-group">
            <label class="col-sm-2 control-label"></label>
            <input type="hidden" name="threshold[id][]" value="{$thresholds.$i.id}" />

            <div class="col-sm-2" style="width:11%;">
                <input type="number" min="1" max="10000" data-error="{$MGLANG->T('Field is required')}" placeholder="1" class="form-control mg-input-quantity" value="{$thresholds.$i.quantity}" name="threshold[quantity][]" requried>
                <div  class="help-block with-errors mg-error-quantity" style="display:none;"></div>
            </div>
            <div class="col-sm-2  control-label" style="text-align: left; padding-left: 0px;">
                {$MGLANG->T('quantity of required products in order')}
            </div>

            <div class="col-sm-2" style="width:11%;">
                <input type="text" data-error="{$MGLANG->T('That value is invalid')}" pattern={literal}"^\d{0,2}(\.\d{0,2})?$"{/literal} placeholder="10.00" class="form-control mg-input-promotion" value="{$thresholds.$i.promotion}" name="threshold[promotion][]" requried>
                <div  class="help-block with-errors mg-error-promotion" style="display:none;"></div>
            </div>
            <div class="col-sm-2  control-label" style="text-align: left; padding-left: 0px;">
                {$MGLANG->T('discount')}
            </div>
            <button  type="button" class="btn btn-primary mg-clone-add" style="" title="{$MGLANG->T('Add Threshold')}">
                <i class="glyphicon glyphicon-plus"></i>
            </button>
            <button  type="button" class="btn btn-danger mg-clone-remove" {if $loopThresholds==1}style="display:none;"{/if} title="{$MGLANG->T('remove')}">
                <i class="glyphicon glyphicon-remove"></i>
            </button>
        </div>
    {/section}
</div>

{literal}
    <script type="text/javascript">
        jQuery(document).ready(function () {
            $("#mg-quantity-apply-type").select2();

            $("#mg-quantity-apply-type").change(function(){
                switch($(this).val()){
                    case 'more_expensive':
                    case 'less_expensive':
                        $("#mg-quantity-group-price").show();
                        $(".mg-promotional-products").addClass("hidden");
                        $("#rules_modal_rules_recurring").parent('.form-group').show();
                        $('input[type=checkbox][name="rules[recurring][]"').trigger('change');
                        $("#mg-discount-unpaidInvoices").parent('.form-group').hide();
                        break;
                    case 'all':
                    case 'paid':
                        $("#mg-quantity-group-price").hide();
                        $(".mg-promotional-products").addClass("hidden");
                        $("#mg-discount-unpaidInvoices").parent('.form-group').hide();
                        break;
                    case 'active_services_quantity':
                        $("#mg-quantity-group-price").hide();
                        $(".mg-promotional-products").addClass("hidden");
                        $("#rules_modal_rules_recurring").parent('.form-group').hide();
                        $("#rules_recurringMonths").closest('.form-group').hide();
                        $("#mg-discount-unpaidInvoices").parent('.form-group').show();
                        break;
                    case 'products':
                        $("#mg-quantity-group-price").hide();
                        $(".mg-promotional-products").removeClass("hidden");
                        $("#rules_modal_rules_recurring").parent('.form-group').show();
                        $('input[type=checkbox][name="rules[recurring][]"').trigger('change');
                        $("#mg-discount-unpaidInvoices").parent('.form-group').hide();
                        break;
                }
            });
            $("#mg-quantity-apply-type").change();
        });

        $("#mg-discount").undelegate(".mg-clone-add", "click");
        $("#mg-discount").delegate(".mg-clone-add", "click", function (e) {
            e.preventDefault();
            var content = $(this).closest('.form-group').clone();
            content.find('input[name="threshold[id][]"]').val('');
            $(this).closest('.form-group').after(content);
            $(".mg-clone-remove").show();

            $("#mg-form-add").validator('destroy');
            $("#mg-form-add").validator('validate');
        });

    </script>
{/literal}